/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.perfield;

import guideme.internal.shaded.lucene.codecs.FieldsProducer;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FieldInfos;
import guideme.internal.shaded.lucene.index.IndexOptions;
import guideme.internal.shaded.lucene.index.MergeState;
import guideme.internal.shaded.lucene.index.Terms;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

final class PerFieldMergeState {
    PerFieldMergeState() {
    }

    static MergeState restrictFields(MergeState in, Collection<String> fields) {
        FieldInfos[] fieldInfos = new FieldInfos[in.fieldInfos.length];
        for (int i = 0; i < in.fieldInfos.length; ++i) {
            fieldInfos[i] = new FilterFieldInfos(in.fieldInfos[i], fields);
        }
        FieldsProducer[] fieldsProducers = new FieldsProducer[in.fieldsProducers.length];
        for (int i = 0; i < in.fieldsProducers.length; ++i) {
            fieldsProducers[i] = in.fieldsProducers[i] == null ? null : new FilterFieldsProducer(in.fieldsProducers[i], fields);
        }
        FilterFieldInfos mergeFieldInfos = new FilterFieldInfos(in.mergeFieldInfos, fields);
        return new MergeState(in.docMaps, in.segmentInfo, mergeFieldInfos, in.storedFieldsReaders, in.termVectorsReaders, in.normsProducers, in.docValuesProducers, fieldInfos, in.liveDocs, fieldsProducers, in.pointsReaders, in.knnVectorsReaders, in.maxDocs, in.infoStream, in.intraMergeTaskExecutor, in.needsIndexSort);
    }

    private static class FilterFieldInfos
    extends FieldInfos {
        private final Set<String> filteredNames;
        private final List<FieldInfo> filtered;
        private final boolean filteredHasVectors;
        private final boolean filteredHasPostings;
        private final boolean filteredHasProx;
        private final boolean filteredHasPayloads;
        private final boolean filteredHasOffsets;
        private final boolean filteredHasFreq;
        private final boolean filteredHasNorms;
        private final boolean filteredHasDocValues;
        private final boolean filteredHasPointValues;

        FilterFieldInfos(FieldInfos src, Collection<String> filterFields) {
            super(FilterFieldInfos.toArray(src));
            boolean hasVectors = false;
            boolean hasPostings = false;
            boolean hasProx = false;
            boolean hasPayloads = false;
            boolean hasOffsets = false;
            boolean hasFreq = false;
            boolean hasNorms = false;
            boolean hasDocValues = false;
            boolean hasPointValues = false;
            this.filteredNames = new HashSet<String>(filterFields);
            this.filtered = new ArrayList<FieldInfo>(filterFields.size());
            for (FieldInfo fi : src) {
                if (!this.filteredNames.contains(fi.name)) continue;
                this.filtered.add(fi);
                hasVectors |= fi.hasTermVectors();
                hasPostings |= fi.getIndexOptions() != IndexOptions.NONE;
                hasProx |= fi.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
                hasFreq |= fi.getIndexOptions() != IndexOptions.DOCS;
                hasOffsets |= fi.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
                hasNorms |= fi.hasNorms();
                hasDocValues |= fi.getDocValuesType() != DocValuesType.NONE;
                hasPayloads |= fi.hasPayloads();
                hasPointValues |= fi.getPointDimensionCount() != 0;
            }
            this.filteredHasVectors = hasVectors;
            this.filteredHasPostings = hasPostings;
            this.filteredHasProx = hasProx;
            this.filteredHasPayloads = hasPayloads;
            this.filteredHasOffsets = hasOffsets;
            this.filteredHasFreq = hasFreq;
            this.filteredHasNorms = hasNorms;
            this.filteredHasDocValues = hasDocValues;
            this.filteredHasPointValues = hasPointValues;
        }

        private static FieldInfo[] toArray(FieldInfos src) {
            FieldInfo[] res = new FieldInfo[src.size()];
            int i = 0;
            for (FieldInfo fi : src) {
                res[i++] = fi;
            }
            return res;
        }

        @Override
        public Iterator<FieldInfo> iterator() {
            return this.filtered.iterator();
        }

        @Override
        public boolean hasFreq() {
            return this.filteredHasFreq;
        }

        @Override
        public boolean hasPostings() {
            return this.filteredHasPostings;
        }

        @Override
        public boolean hasProx() {
            return this.filteredHasProx;
        }

        @Override
        public boolean hasPayloads() {
            return this.filteredHasPayloads;
        }

        @Override
        public boolean hasOffsets() {
            return this.filteredHasOffsets;
        }

        @Override
        public boolean hasTermVectors() {
            return this.filteredHasVectors;
        }

        @Override
        public boolean hasNorms() {
            return this.filteredHasNorms;
        }

        @Override
        public boolean hasDocValues() {
            return this.filteredHasDocValues;
        }

        @Override
        public boolean hasPointValues() {
            return this.filteredHasPointValues;
        }

        @Override
        public int size() {
            return this.filtered.size();
        }

        @Override
        public FieldInfo fieldInfo(String fieldName) {
            if (!this.filteredNames.contains(fieldName)) {
                throw new IllegalArgumentException("The field named '" + fieldName + "' is not accessible in the current merge context, available ones are: " + String.valueOf(this.filteredNames));
            }
            return super.fieldInfo(fieldName);
        }

        @Override
        public FieldInfo fieldInfo(int fieldNumber) {
            FieldInfo res = super.fieldInfo(fieldNumber);
            if (!this.filteredNames.contains(res.name)) {
                throw new IllegalArgumentException("The field named '" + res.name + "' numbered '" + fieldNumber + "' is not accessible in the current merge context, available ones are: " + String.valueOf(this.filteredNames));
            }
            return res;
        }
    }

    private static class FilterFieldsProducer
    extends FieldsProducer {
        private final FieldsProducer in;
        private final List<String> filtered;

        FilterFieldsProducer(FieldsProducer in, Collection<String> filterFields) {
            this.in = in;
            this.filtered = new ArrayList<String>(filterFields);
        }

        @Override
        public Iterator<String> iterator() {
            return this.filtered.iterator();
        }

        @Override
        public Terms terms(String field) throws IOException {
            if (!this.filtered.contains(field)) {
                throw new IllegalArgumentException("The field named '" + field + "' is not accessible in the current merge context, available ones are: " + String.valueOf(this.filtered));
            }
            return this.in.terms(field);
        }

        @Override
        public int size() {
            return this.filtered.size();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }
    }
}

